<?php
session_start();
require 'admin/db-connection.php';
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $authToken = $_GET['Authorization'] ?? '';
    $data_type = $_GET['data_type'] ?? '';

    if ($authToken !== 'WREDS!@453') {
        echo json_encode([
            'status' => false,
            'message' => 'Unauthorized access.'
        ]);
        exit;
    }
    $response = [
        'status' => true,
        'message' => 'Data fetched successfully.',
        'data' => []
    ];
    if ($data_type === 'ProductLead') {
        $query = "SELECT u.*,
                    COUNT(o.id) AS total_order,
                    GROUP_CONCAT(DISTINCT o.product_name SEPARATOR ', ') AS product_names
                    FROM tbl_user AS u 
                            LEFT JOIN tbl_order AS o ON u.id = o.user_id 
                            WHERE o.status IN (2) 
                            GROUP BY u.id 
                            ORDER BY u.created_at DESC";
    } elseif ($data_type === 'Lead') {
        $query = "SELECT u.*, COUNT(o.id) AS total_order
                    FROM tbl_user AS u 
                    LEFT JOIN tbl_order AS o ON u.id = o.user_id 
                    WHERE o.status IN (1, 3)
                    GROUP BY u.id 
                    ORDER BY u.created_at DESC";
    } elseif ($data_type === 'checkout') {
        $query = "SELECT  
                    o.id,
                    o.product_name,
                    o.order_id,
                    o.user_id,
                    o.status,
                    CASE 
                        WHEN o.status = 5 THEN 'Online Delivery' 
                        ELSE 'Cash On Delivery' 
                    END AS status_text,
                    o.payment_method,
                    o.product_discount_promo,
                    o.payment_discount,
                    o.product_price,
                    o.total_amount,
                    o.created_at,
                    u.name,
                    u.mobile,
                    u.email,
                    u.zip_code,
                    u.landmark,
                    u.house_no,
                    u.city,
                    u.state
                FROM tbl_order AS o 
                LEFT JOIN tbl_user AS u ON u.id = o.user_id 
                WHERE o.status IN (4, 5)
                ORDER BY o.id DESC";
    } else {
        echo json_encode([
            'status' => false,
            'message' => 'Invalid data_type provided.'
        ]);
        exit;
    }
    $result = mysqli_query($link, $query);
    if ($result && mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $response['data'][] = $row;
        }
    }


    // Before encoding
    $response = utf8ize($response);
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}
function utf8ize($data)
{
    if (is_array($data)) {
        foreach ($data as $key => $value) {
            $data[$key] = utf8ize($value);
        }
    } elseif (is_string($data)) {
        $data = mb_convert_encoding($data, 'UTF-8', 'UTF-8');
    }
    return $data;
}