<?php 
include('auth.php');
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="description" content="Web Development Solution is a professional service provider company envisioned to acclaim website related services and deploy an array of technologies to build-up brands over the Internet globally. Considering ourselves as a medium of change, our resolution is to provide brands an ultimate satisfaction to reinvent their world digitally. We create and build acquaintances you’re your clientele. Our definitive goal is to render your business an intelligent, exclusive, and direct reflection in the digital world to fetch you a high return.">
    <meta name="author" content="webdevelopmentsolution">
    <meta name="keywords" content="webdevelopmentsolution,Admin Login">
    <title>Admin Dashboard</title>

    <?php
    include('includes/header-links.php');
    ?>
</head>

<body>
    <div class="main-wrapper">
        <?php
        include('includes/left-sidebar.php');
        ?>
        <div class="page-wrapper">
            <?php
            include('includes/topbar.php');
            ?>
            <div class="page-content">
                <div class="d-flex justify-content-between align-items-center flex-wrap grid-margin">
                    <div>
                        <h4 class="mb-3 mb-md-0">Add User Management</h4>
                    </div>
                    <div class="d-flex align-items-center flex-wrap text-nowrap btn btn-primary btn-icon-text">
                        <a href="user-list.php" style="color:#fff !important;"><i class="fa fa-user"></i>  User List</a>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12 col-xl-12 grid-margin stretch-card">
                        <div class="card overflow-hidden">
                            <div class="card-body">
                                <form class="forms-sample">
                                    <div class="row mb-3">
                                        <label for="inputFullName" class="col-sm-3 col-form-label">Full Name</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" id="inputFullName" placeholder="Full Name" required aria-required="true" maxlength="100">
                                        </div>
                                    </div>
                                    <!-- Email Field -->
                                    <div class="row mb-3">
                                        <label for="inputEmail" class="col-sm-3 col-form-label">Email</label>
                                        <div class="col-sm-9">
                                            <input type="email" class="form-control" id="inputEmail" autocomplete="off" placeholder="Email" required aria-required="true" maxlength="100">
                                        </div>
                                    </div>
                                    <!-- Mobile Field -->
                                    <div class="row mb-3">
                                        <label for="inputMobile" class="col-sm-3 col-form-label">Mobile</label>
                                        <div class="col-sm-9">
                                            <input type="tel" class="form-control" id="inputMobile" placeholder="Mobile Number" pattern="[0-9]{10}" required aria-required="true" maxlength="10">
                                        </div>
                                    </div>

                                    <!-- Address Section -->
                                    <h5 class="mb-4">Address Details</h5>
                                    <!-- Address Field -->
                                    <div class="row mb-3">
                                        <label for="inputAddress" class="col-sm-3 col-form-label">Address</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" id="inputAddress" placeholder="Street Address" required aria-required="true" maxlength="255">
                                        </div>
                                    </div>
                                    <!-- PIN Code Field -->
                                    <div class="row mb-3">
                                        <label for="inputPin" class="col-sm-3 col-form-label">PIN Code</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" id="inputPin" placeholder="PIN Code" pattern="[0-9]{6}" required aria-required="true" maxlength="6">
                                        </div>
                                    </div>
                                    <!-- District Field -->
                                    <div class="row mb-3">
                                        <label for="inputDistrict" class="col-sm-3 col-form-label">District</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" id="inputDistrict" placeholder="District" required aria-required="true" maxlength="100">
                                        </div>
                                    </div>
                                    <!-- State Field -->
                                    <div class="row mb-3">
                                        <label for="inputState" class="col-sm-3 col-form-label">State</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" id="inputState" placeholder="State" required aria-required="true" maxlength="100">
                                        </div>
                                    </div>
                                    <!-- Country Field -->
                                    <div class="row mb-3">
                                        <label for="inputCountry" class="col-sm-3 col-form-label">Country</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" id="inputCountry" placeholder="Country" required aria-required="true" maxlength="100">
                                        </div>
                                    </div>

                                    <!-- Profile Upload Section -->
                                    <h5 class="mb-4">Profile Upload</h5>
                                    <!-- Profile Upload -->
                                    <div class="row mb-3">
                                        <label for="inputProfile" class="col-sm-3 col-form-label">Profile</label>
                                        <div class="col-sm-9">
                                            <input type="file" class="form-control" id="inputProfile" accept=".jpg,.jpeg,.png,.pdf" aria-required="true">
                                        </div>
                                    </div>

                                    <!-- Buttons -->
                                    <div class="row">
                                        <div class="col-sm-9 offset-sm-3">
                                            <button type="submit" class="btn btn-primary me-2" aria-label="Submit form">Submit</button>
                                            <button type="button" class="btn btn-secondary" aria-label="Cancel form">Cancel</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <?php
            include('includes/footer.php');
            ?>
            <style>
                table.dataTable thead th .dt-column-order:before {
                    font-family: FontAwesome;
                    padding-left: 5px;
                    content: "\f0dc";
                    /* FontAwesome 'sort' icon (default) */
                }

                table.dataTable thead th.sorting_asc .dt-column-order:before {
                    content: "\f160";
                    /* FontAwesome 'sort-up' icon for ascending */
                }

                table.dataTable thead th.sorting_desc .dt-column-order:before {
                    content: "\f161";
                    /* FontAwesome 'sort-down' icon for descending */
                }
            </style>

            <script>
                $(document).ready(function() {
                    $('#userdatatable').DataTable({
                        "paging": true,
                        "searching": true,
                        "ordering": true, // Ensures that columns are sortable
                        "info": true,
                        "lengthChange": true,
                        "pageLength": 5,
                        "columnDefs": [{
                                "orderable": false,
                                "targets": [4]
                            } // Disable sorting for specific columns (if needed)
                        ]

                    });
                });
            </script>