<?php
session_start();
if (isset($_SESSION['user_name'])) {
    $s_id = $_SESSION['user_id'] ?? '';
    $s_name = $_SESSION['user_name'] ?? '';
    $s_phone = $_SESSION['user_phone'] ?? '';
    $s_selected_package = $_SESSION['user_selected_package'] ?? '';
} else {
    header('Location: index.php');
    exit();
}
?>
<!doctype html>
<html class="no-js" lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Shrichitt Urja Vati | Natural Men's Wellness & Vitality Booster</title>
    <meta name="description" content="Revitalize your strength and stamina naturally with Shrichitt Urja Vati. Enhance energy, improve endurance, support hormonal balance, and promote overall men's wellness.">
    <meta name="keywords" content="Shrichitt Urja Vati, men's wellness, vitality booster, natural stamina supplement, energy enhancer, strength and endurance, hormonal balance, ayurvedic wellness capsule">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="author" content="Shrichitt">


    <!-- Canonical URL (avoid duplicate SEO issues) -->
    <link rel="canonical" href="https://urjavati.com/online-order">

    <!-- Favicon -->
    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon_io/favicon.ico">
    <link rel="apple-touch-icon" sizes="180x180" href="assets/img/favicon_io/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="assets/img/favicon_io/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="assets/img/favicon_io/favicon-16x16.png">

    <!-- Open Graph (Facebook & LinkedIn) -->
    <meta property="og:title" content="Shrichitt Urja Vati | Natural Men's Wellness & Vitality Booster">
    <meta property="og:description" content=" your strength and stamina naturally with Shrichitt Urja Vati. Enhance energy, improve endurance, support hormonal balance, and promote overall men's wellness.">
    <meta property="og:type" content="product">
    <meta property="og:url" content="https://urjavati.com/online-order/">
    <meta property="og:image" content="https://urjavati.com/online-order/banner/height-detox-benefit.webp">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Shrichitt Urja Vati | Natural Men's Wellness & Vitality Booster">
    <meta name="twitter:description" content=" your strength and stamina naturally with Shrichitt Urja Vati. Enhance energy, improve endurance, support hormonal balance, and promote overall men's wellness.">
    <meta name="twitter:image" content="https://urjavati.com/online-order/banner/height-detox-benefit.webp">
    <!-- Place favicon.ico in the root directory -->
    <!-- CSS here -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/animate.min.css">
    <link rel="stylesheet" href="assets/css/magnific-popup.css">
    <link rel="stylesheet" href="assets/css/fontawesome-all.min.css">
    <link rel="stylesheet" href="assets/css/flaticon.css">
    <link rel="stylesheet" href="assets/css/jquery-ui.css">
    <link rel="stylesheet" href="assets/css/odometer.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/lightcase/2.5.0/css/lightcase.css">
    <link rel="stylesheet" href="assets/css/slick.css">
    <link rel="stylesheet" href="assets/css/default.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/magnific-popup.min.css">
    <link rel="stylesheet" href="assets/css/responsive.css">
    <style>
        .container_otp {
            background-color: #1e1e1e;
            padding: 2rem;
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.3);
            text-align: center;
            max-width: 400px;
            margin: auto;
        }

        .container_otp h1 {
            margin-bottom: 1rem;
            color: #ffffff;
            font-size: 20px;
        }

        .container_otp p {
            color: #cccccc;
        }

        .container_otp .otp-input {
            display: flex;
            justify-content: center;
            margin-bottom: 1rem;
        }

        .container_otp .otp-input input {
            width: 40px;
            height: 40px;
            margin: 0 5px;
            text-align: center;
            font-size: 1.2rem;
            border: 1px solid #444;
            border-radius: 4px;
            background-color: #2a2a2a;
            color: #ffffff;
            outline: none;
        }

        .container_otp .otp-input input:focus {
            border-color: #ff9800;
            box-shadow: 0 0 5px rgba(255, 152, 0, 0.5);
        }

        .otp-input input::-webkit-outer-spin-button,
        .otp-input input::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }

        .container_otp .otp-input input[type="number"] {
            -moz-appearance: textfield;
        }

        .container_otp button {
            background-color: #4CAF50;
            color: white;
            border: none;
            padding: 10px 20px;
            font-size: 1rem;
            border-radius: 4px;
            cursor: pointer;
            margin: 5px;
            transition: background-color 0.3s ease;
        }

        .container_otp button:hover {
            background-color: #45a049;
        }

        .container_otp button:disabled {
            background-color: #cccccc;
            color: #666666;
            cursor: not-allowed;
        }

        .container_otp #timer {
            font-size: 1.2rem;
            margin-bottom: 1rem;
            color: #ff9800;
        }

        .bgcactive {
            background-color: #d2e4d8 !important;
        }

        /* Define the default zoom_in_out class */
        .zoom_in_out {
            transition: transform 0.3s ease-in-out;
            /* Smooth transition for zoom */
        }

        /* Zoom-in effect (when activated via jQuery) */
        .zoom-effect {
            transform: scale(1.02);
            /* Zoom by 2% */
        }

        table {
            width: 100%;
            background: #efefef;
        }

        table,
        th,
        td {
            border: 1px solid #d5d5d5;
            border-collapse: collapse;
        }

        th,
        td {
            padding: 10px;
            width: 50%;
        }

        p.error_form {
            color: red;
            font-size: 12px;
            font-weight: bold;
        }
    </style>
    
    <!-- Meta Pixel Code -->
<script>
!function(f,b,e,v,n,t,s)
{if(f.fbq)return;n=f.fbq=function(){n.callMethod?
n.callMethod.apply(n,arguments):n.queue.push(arguments)};
if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
n.queue=[];t=b.createElement(e);t.async=!0;
t.src=v;s=b.getElementsByTagName(e)[0];
s.parentNode.insertBefore(t,s)}(window, document,'script',
'https://connect.facebook.net/en_US/fbevents.js');
fbq('init', '1400084021353349');
fbq('track', 'InitiateCheckout');
</script>
<noscript><img height="1" width="1" style="display:none"
src="https://www.facebook.com/tr?id=1400084021353349&ev=PageView&noscript=1"
/></noscript>
<!-- End Meta Pixel Code -->
<!-- Meta Pixel Code -->
<script>
!function(f,b,e,v,n,t,s)
{if(f.fbq)return;n=f.fbq=function(){n.callMethod?
n.callMethod.apply(n,arguments):n.queue.push(arguments)};
if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
n.queue=[];t=b.createElement(e);t.async=!0;
t.src=v;s=b.getElementsByTagName(e)[0];
s.parentNode.insertBefore(t,s)}(window, document,'script',
'https://connect.facebook.net/en_US/fbevents.js');
fbq('init', '1400084021353349');
fbq('track', 'PageView');
fbq('track', 'Contact');
</script>
<noscript><img height="1" width="1" style="display:none"
src="https://www.facebook.com/tr?id=1400084021353349&ev=PageView&noscript=1"
/></noscript>
<!-- End Meta Pixel Code -->
</head>

<body>



    <!-- Pre-loader-start -->
    <!-- <div id="preloader">
        <div class="tg-cube-grid">
            <div class="tg-cube tg-cube1"></div>
            <div class="tg-cube tg-cube2"></div>
            <div class="tg-cube tg-cube3"></div>
            <div class="tg-cube tg-cube4"></div>
            <div class="tg-cube tg-cube5"></div>
            <div class="tg-cube tg-cube6"></div>
            <div class="tg-cube tg-cube7"></div>
            <div class="tg-cube tg-cube8"></div>
            <div class="tg-cube tg-cube9"></div>
        </div>
    </div> -->
    <!-- Pre-loader-end -->



    <section class=" bgcimgcheck" style="background-image: url(./checkout/checkout-bg.jpg);">
        <div class="container1 bgcclrsddcheck">
            <div class="row py-3">
                <div class="col-lg-12">
                    <div class="row">
                        <div class="col-lg-4 col-4 my-auto text-left lgggh">
                            <a href="index.php"> <img src="assets/img/logo/logo.webp" alt=""></a>
                        </div>
                        <div class="col-lg-4 col-4 my-auto">
                            <div class="row">
                                <div class="col-lg-4 col-5 my-auto text-end imgssdchck">
                                    <img src="checkout/one.png" alt="">
                                </div>
                                <div class="col-lg-8 col-7 text-left imgssdchck1 my-auto">
                                    <img src="checkout/two.webp" alt="">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-4 my-auto text-center ">
                            <img src="checkout/three.png" alt="">
                        </div>
                    </div>
                </div>
            </div>
            <div class="row pb-4">
                <div class="col-lg-12 text-center contsdn">
                    <h3>GO CASHLESS. PAY VIA CREDIT/DEBIT CARD ONLINE BANKING, WALLET &amp; GET
                        <span style="color: red; font-weight: 700;" class="blink_me">INSTANT 5% DISCOUNT</span>
                    </h3>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-7 checkmrgssd">
                    <div class="vouchertoggle mb-3 d-none">
                        <div class="code-active promo-code-part form-row justify-content-center ">
                            <img src="discount/offer-badg.png" class="img-badg">
                            <h4>Apply Discount Code  <strong>Get Extra 100RS OFF</strong></h4>
                            <div style="padding-top: 5px;width: 100%;">
                                Offer Will expire in &nbsp;
                                <span id="tmr">5:00</span>
                            </div>
                            <div>
                                <span>LOYAL</span>
                                <input id="promo-code" type="hidden" class="form-control" name="voucher" value="LOYAL">
                                <button type="submit" class="btn btn-info btn-apply-promo">Apply Discount</button>
                            </div>
                            <br>
                        </div>
                    </div>
                    <!-- BEST SELLER
                    DOCTOR'S RECOMMENDED
                    MOST POPULAR -->
                    <?php
                    $pro_img1 = ($s_selected_package == '1') ? 'checkout/pack1-s.jpg' : 'checkout/pack1.jpg';
                    $pro_img2 = ($s_selected_package == '2') ? 'checkout/pack1-2.jpg' : 'checkout/pack2.jpg';
                    $pro_img3 = ($s_selected_package == '3') ? 'checkout/pack1-3.jpg' : 'checkout/pack3.jpg';
                    ?>
                    <img src="<?= $pro_img1 ?>" alt="" id='package_1' data-item_name="MOST POPULAR" data-item_price="999">
                    <img src="<?= $pro_img2 ?>" alt="" id='package_2' data-item_name="DOCTOR'S RECOMMENDED" data-item_price="1599">
                    <img src="<?= $pro_img3 ?>" alt="" id='package_3' data-item_name="BEST SELLER" data-item_price="2950">
                    <div class="row">
                        <div class="col-lg-12 mt-5 brderper">
                            <div class="row">
                                <div class="col-lg-2 col-3 my-auto">
                                    <img src="checkout/moneyback-guarantee.svg" alt="">
                                </div>
                                <div class="col-lg-10 col-9 ">
                                    <h6 style="margin-bottom:4px;"><b style="font-size:14px;">100% MONEY BACK
                                            GUARANTEE</b></h6>
                                    <p style="font-size:0.70rem;">
                                        <b>
                                            <span style="font-weight:900;">Our Promise: Easy Refund and Pick Up</span> -
                                            If you
                                            don't
                                            boost your performance naturally, simply call us and we will give you a full 100%
                                            hassle-free refund. We
                                            stand
                                            behind our product. <br> <i style="color:orange;">Try it, Risk Free.</i>
                                        </b>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-5 mrginsssd">
                    <div class="px-2">
                        <div id="formtop" class="col-12 border p-3 text-center">
                            <b class="text-black text-uppercase">Where do we ship your Urjavati capsule ?</b>
                        </div>
                        <div id="formbottom" class="col-12 border p-3">
                            <form class="frmpdss" id="checkoutform">
                                <?php
                                //get User data 
                                include 'admin/db-connection.php';
                                $query_user = "SELECT * FROM `tbl_user` WHERE mobile= '$s_phone'";
                                $result_user = mysqli_query($link, $query_user);
                                $row_user = mysqli_fetch_assoc($result_user);
                                if (!empty($row_user)) {
                                    $city = $row_user['city'];
                                    $state = $row_user['state'];
                                    $email = $row_user['email'];
                                    $zip_code = $row_user['zip_code'];
                                    $landmark = $row_user['landmark'];
                                    $house_no = $row_user['house_no'];
                                } else {
                                    $city = '';
                                    $state = '';
                                    $email = '';
                                    $zip_code = '';
                                    $landmark = '';
                                    $house_no = '';
                                }

                                ?>
                                <div class="row ">
                                    <div class="col-lg-12 mb-3">
                                        <input type="text" class="form-control" name="first_name" placeholder="Full name" value="<?= $s_name ?>">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-12 mb-3">
                                        <input type="text" class="form-control" name="zip_code" placeholder="Pincode" required autocomplete="postal-code"
                                            value="<?= $zip_code ?>" pattern="\d{6}" inputmode="numeric" maxlength="6" title="Please enter a 6-digit pincode">

                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <input type="text" value="<?= $house_no ?>" class="form-control" name="address1" placeholder="Flat No. / House No. / Street">
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <input type="text" value="<?= $landmark ?>" class="form-control" name="address2" placeholder="Landmark">
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <input type="text" value="<?= $city ?>" class="form-control" name="city" id="city" placeholder="City">
                                    </div>

                                    <div class="col-lg-6 mb-3">
                                        <input type="text" value="<?= $zip_code ?>" class="form-control" name="state" id="state" placeholder="state">

                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <input type="email" value="<?= $email ?>" name="email" id="email" class="form-control" placeholder="Email (optional)">
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <div class="input-group mb-3">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text" style="padding:.2em">+91</span>
                                            </div>
                                            <input type="tel" maxlength="10" minlength="10" data-mask="0000000000" name="phone" id="phone" class="form-control" placeholder="Mob. Number" autocomplete="off" value="<?= $s_phone ?>">
                                            <span class="invalid-feedback" role="alert">
                                                <strong></strong>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="shiping-method-bg">
                                        <div class="col-lg-12 mb-12 smethod text-center">
                                            <span class="shipping-method">Shipping Method</span>
                                        </div>
                                        <div class="col-lg-12 mb-12 d-none" style="margin-top: 20px;">
                                            <div class="row">
                                                <div class="col-lg-6 mb-12 clrssd">
                                                    <input type="radio" name="payment_method" value="online" >
                                                    Pay Online <br>
                                                    <span class="delivery-subtitle">(Delivers in 2-3 Business
                                                        Days)</span>
                                                </div>
                                                <div class="col-lg-6 mb-12 " id="onlineshipp">
                                                    <span class="price offer_payment_discount" data-offerdiscount='0' style=" color: red; "> 5% Off + Overnight Shipping</span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 mb-12">
                                            <hr>
                                        </div>
                                        <div class="col-lg-12 mb-12">
                                            <div class="row">
                                                <div class="col-lg-6 mb-12 clrssd">
                                                    <input type="radio" name="payment_method" value="cod" checked=""> Cash
                                                    On
                                                    Delivery <br>
                                                    <span class="delivery-subtitle">(Delivers in 5-7 Business
                                                        Days)</span>
                                                </div>
                                                <div class="col-md-6 mb-12">
                                                    <span class="price"> Normal Shipping</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-12 mb-12">
                                        <?php
                                        $pro_amount = ($s_selected_package == '1') ? '999' : (($s_selected_package == "2") ? '1599' : (($s_selected_package == '3') ? '2950' : 0));
                                        if ($s_selected_package == '1') {
                                            $pro_name = 'MOST POPULAR';
                                        } elseif ($s_selected_package == '2') {
                                            $pro_name = "DOCTOR'S RECOMMENDED";
                                        } elseif ($s_selected_package == '3') {
                                            $pro_name = 'BEST SELLER';
                                        } else {
                                            $pro_name = 0;
                                        }

                                        // echo $pro_amount;
                                        //discount_amount
                                        // $discount_amount = $pro_amount * 5 / 100;
                                        $discount_amount =0;
                                        ?>
                                        <table class="chektble">
                                            <tbody>
                                                <tr>
                                                    <th>Product</th>
                                                    <th>
                                                        <input type="hidden" name="product_name" class="product_name" value="<?= $pro_name ?>">
                                                        <span style="border:0px; background:#efefef;" class="product_name_text">
                                                            <?= $pro_name ?>
                                                        </span>
                                                    </th>
                                                </tr>
                                                <tr>
                                                    <td>Price</td>
                                                    <td>Rs.&nbsp;
                                                        <input type="hidden" name="product_price" class="product_price" value="<?= $pro_amount ?>">
                                                        <span style="border:0px; background:#efefef; width:40%;" class="product_price_text"><?= $pro_amount ?></span> &nbsp;/-
                                                    </td>
                                                </tr>
                                                <tr class="btn-apply-promo-tr d-none">
                                                    <td>Voucher</td>
                                                    <td>Rs.&nbsp;
                                                        <input type="hidden" name="product_discount_promo" class="product_discount_promo" value="0">
                                                        <span style="border:0px; background:#efefef; width:40%;" class="product_discount_promo_text">0</span> &nbsp;/-
                                                    </td>
                                                </tr>

                                                <tr class="payment_discount_tr d-none">
                                                    <td>Payment Discount</td>
                                                    <td>Rs.&nbsp;
                                                        <input type="hidden" name="payment_discount" class="payment_discount" value="<?= $discount_amount ?>">
                                                        <span style="border:0px; background:#efefef; width:40%;" class="payment_discount_text"><?= $discount_amount ?></span>&nbsp;/-
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>Total</td>
                                                    <td>Rs.&nbsp;
                                                        <input type="hidden" name="total_amount" class="total_amount" value="<?= $pro_amount - $discount_amount ?>">
                                                        <span style="border:0px; background:#efefef; width:40%;" class="total_amount_text"><?= $pro_amount - $discount_amount ?></span> &nbsp;/-
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                                <div class="form-row plcholdrimg">
                                    <div class="col-12 text-center">
                                        <!-- Progress Bar -->
                                        <div class="progress d-none  mx-auto" id="progress_bar" style="max-width: 300px;">
                                            <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100" style="width: 100%; background-color:#03762e;"></div>
                                        </div>
                                        <!-- Submit Button -->
                                        <div class="form_btn position-relative d-inline-block">
                                            <button type="submit" style="border: 0; background: transparent" name="submitType" id="submitType">
                                                <img src="checkout/four.png" class="img-fluid">
                                            </button>
                                        </div>
                                        <div class="alert alert-danger d-none" role="alert" id="checkout_error_res"></div>
                                        <div class="alert alert-success d-none" role="alert" id="checkout_success_res"></div>
                                        <!-- OTP Verification Section -->
                                        <!-- <div class="row  d-none" id="otp_Verify_html">
                                            <div class="col-lg-12">
                                                <div class="d-flex justify-content-center">
                                                    <input class="otp" id="otp1" type="text" oninput="digitValidate(this)" onkeyup="tabChange(1)" maxlength="1">
                                                    <input class="otp" id="otp2" type="text" oninput="digitValidate(this)" onkeyup="tabChange(2)" maxlength="1" disabled>
                                                    <input class="otp" id="otp3" type="text" oninput="digitValidate(this)" onkeyup="tabChange(3)" maxlength="1" disabled>
                                                    <input class="otp" id="otp4" type="text" oninput="digitValidate(this)" onkeyup="tabChange(4)" maxlength="1" disabled>
                                                </div>
                                            </div>
                                            <div class="col-lg-12">
                                                <button class='btn btn-primary btn-block mt-4  customBtn' id="Verifyotp">Verify</button>
                                            </div>
                                            <div class="col-lg-12 mt-3">
                                                <button class="btn btn-secondary btn-block customBtn" style="background-color:#ff7300 !important;" id="resendOtpBtn" type="button">Resend OTP</button>
                                            </div>
                                        </div> -->


                                        <div class="container_otp d-none" id="otp_Verify_html">
                                            <h1>OTP Verification</h1>
                                            <p>Enter the 4-digit code sent to your device</p>
                                            <div id="timer">Time remaining: 03:00</div>
                                            <div class="otp-input">
                                                <input type="number" min="0" max="9" maxlength="1" required tabindex="1" aria-label="OTP digit 1">
                                                <input type="number" min="0" max="9" maxlength="1" required tabindex="2" aria-label="OTP digit 2">
                                                <input type="number" min="0" max="9" maxlength="1" required tabindex="3" aria-label="OTP digit 3">
                                                <input type="number" min="0" max="9" maxlength="1" required tabindex="4" aria-label="OTP digit 4">
                                            </div>
                                            <button onclick="verifyOTP()" type='button'>Verify</button>
                                            <button id="resendButton" onclick="resendOTP()" type='button' disabled>Resend Code</button>
                                        </div>
                                        <!-- Buy Now Button -->
                                        <div class="row d-none" id="buy_now_btn">
                                            <div class="col-lg-12">
                                                <button class='btn btn-primary btn-block  mb-4  customBtn' id="buynowbtn" type='button'>Buy Now</button>
                                            </div>
                                        </div>
                                        <br>
                                        <!-- Additional Image -->
                                        <span><img src="checkout/five.png" class="img-fluid"></span><br>
                                        <!-- Security Message -->
                                        <!-- <span style="color:#000;">256 bit secure form</span> -->
                                    </div>
                                </div>

                            </form>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="pt-60 pb-60">
        <div class="container1">
            <div class="row">
                <div class="col-lg-7">
                    <div class="s2-lft">
                        <h1 class="s2-rvw-hdng">Customer Reviews </h1>
                        <p class="s2-rvw-txt1"></p>
                        <p>Our customers love our Urjavati Here are some testimonials from those who have enjoyed a
                            healthier lifestyle with Urjavati capsules !</p>
                        <img src="checkout/ovrall-ratng.jpg" class="ovrall-ratng">
                        <div class="custmr-review"> <img src="checkout/star.png" class="star">
                            <p class="rvw-about">I've recommended these capsules to friends and family, and they've all experienced improvements in their sexual health and energy levels. </p>
                            <p class="rvw-name">Kirti A- 14/03/2024</p>
                        </div>
                        <div class="custmr-review"> <img src="checkout/star.png" class="star">
                            <p class="rvw-about"> My sexual drive and performance have significantly improved since using these capsules. I'm more active and content.
                            </p>
                            <p class="rvw-name">Mitesh- 22/05/2024</p>
                        </div>
                        <div class="custmr-review"> <img src="checkout/star.png" class="star">
                            <p class="rvw-about">I'm impressed with the effectiveness of these capsules. They've made a significant difference in my sexual performance.
                            </p>
                            <p class="rvw-name">Shobha Jain- 18/02/2024</p>

                        </div>
                        <div class="custmr-review"> <img src="checkout/star.png" class="star">
                            <p class="rvw-about">I can't express how thankful I am for these capsules. They've enhanced my energy levels and made me feel more vital.
                            </p>
                            <p class="rvw-name">Suraj- 08/04/2024</p>

                        </div>
                        <div class="custmr-review"> <img src="checkout/star.png" class="star">
                            <p class="rvw-about">These capsules are worth every penny. They've improved my sexual health and overall well-being.


</p>
                            <p class="rvw-name">Riya- 02/05/2024</p>

                        </div>
                    </div>
                </div>
                <div class="col-lg-5">
                    <div class="s2-rgt-faq">
                        <h2 class="faq-hdng">Faq</h2>
                        <div class="qstn-dv">
                            <p class="faq-qestn"><span>Q.</span> Does this treatment include any surgery?</p>
                            <p class="faq-ans"><span>A.</span>Urja vati treatment does not involve surgery and is treated naturally using Ayurvedic treatment methods.
                            </p>
                        </div>
                        <div class="qstn-dv">
                            <p class="faq-qestn"><span>Q.</span>My partner and I have lost interest in sex will this treatment help us?</p>
                            <p class="faq-ans"><span>A.</span>This is a very common problem and it can be reversed through Urja vati treatment along with counseling programs with the help of Our doctors.</p>
                        </div>
                        <div class="qstn-dv">
                            <p class="faq-qestn"><span>Q.</span> Can Urja vati treatment help in erectile dysfunction?</p>
                            <p class="faq-ans"><span>A.</span>Erectile dysfunction requires long-term treatment to improve the condition. You can experience 30-40% improvements in 1-3 years.</p>
                        </div>
                        <div class="qstn-dv">
                            <p class="faq-qestn"><span>Q.</span> Is  Urja vati treatment the same as IVF?</p>
                            <p class="faq-ans"><span>A.</span>No, not at all. Urja vati is a natural Ayurvedic detoxification program to remove toxins and imbalances from your body which in turn will help in natural conception.
                            </p>
                        </div>
                        <div class="qstn-dv">
                            <p class="faq-qestn"><span>Q.</span>Are Urjavati capsules safe?
                            </p>
                            <p class="faq-ans"><span>A.</span>Ayurvedic medicines are generally considered safe when used as directed and purchased from reputable sources. However, individual reactions may vary, so it's essential to consult with a healthcare professional before starting any new supplement, especially for children.</p>
                        </div>
                        <div class="qstn-dv">
                            <p class="faq-qestn"><span>Q.</span>Are there any dietary or lifestyle recommendations to enhance the effectiveness of Urjavati capsules ?</p>
                            <p class="faq-ans"><span>A.</span>Maintaining a balanced diet, regular exercise, and proper sleep can contribute to overall growth and may complement the effects of these capsules.
Remember that individual responses to Ayurvedic height increase capsules can vary.</p>
                        </div>
                    </div>
                </div>
            </div>

        </div>

    </section>
    <!-- header-area-end -->
    <!-- Footer-area -->
    <footer class="footer-style-two">
        <div class="footer-two-top-wrap">
            <div class="container">
                <div class="footer-two-widgets-wrap">
                    <div class="row justify-content-between">
                        <div class=" col-lg-6 offset-lg-3 text-center">
                            <div class="footer-widget">
                                <div class="footer-about">
                                    <div class="footer-logo logo">
                                        <a href="index.php"><img src="assets/img/logo/logo-footer.webp" alt="Logo"></a>
                                    </div>
                                    <div class="footer-text">
                                        <p>Urja Vati Capsule is a revolutionary combination of natural herbs and roots, specially prepared and packed to provide complete sexual wellness benefits. It enhances female and male vitality by improving the function of reproductive organs, reducing the stress hormone cortisol in the body thereby balancing hormones levels and supporting overall health. Urja Vati Capsule helps in improving your desires, sexual drive and performance much more. It also helps in increasing fertility and staying active in bed while giving you a feeling of happiness.</p>
                                    </div>
                                    <div class="bgcclrss col-lg-10 offset-lg-1">
                                        <div class="row">
                                            <div class="col-lg-4 col-4 bgcssgd text-right">
                                                <img src="checkout/two.webp">
                                            </div>
                                            <div class="col-lg-8 col-8 my-auto contsshd">
                                                <h4>FSSAI LIC No. : 13323001000231</h4>
                                            </div>
                                        </div>
                                    </div>

                                    <ul class="lissttsd">
                                        <li><a href="privacy-policy.php">Privacy Policy</a></li>
                                        <li><a href="tearm-and-condition.php">Tearm & Condition</a></li>
                                        <li><a href="refund-policy.php">Refund Policy</a></li>
                                    </ul>

                                    <div class="footer-social">
                                        <a href="#"><i class="fab fa-facebook-f"></i></a>
                                        <a href="#"><i class="fab fa-twitter"></i></a>
                                        <a href="#"><i class="fab fa-instagram"></i></a>
                                        <a href="#"><i class="fab fa-linkedin-in"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <div class="copyright-wrap">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-md-12 text-center">
                        <div class="copyright-text">
                            <p>© Copyright 2024 Kayashree. All Rights Reserved.</br>
                            </p>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </footer>
    <!-- Footer-area-end -->
    <!-- start onload popup section -->
    <div id="myModal" class="modal fade" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Modal Header</h4>
                </div>
                <div class="modal-body">
                    <p>Some text in the modal.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>

        </div>
    </div>
    <!-- end onload popup section -->
    <!-- start first whatsapp section -->
    <a href="https://wa.me/918929222323?text=" target=”_blank” class="whatsapp-btn">
        <i class="fab fa-whatsapp"></i>
    </a>
    <a href="tel:+918929222323" target=”_blank” class="phone-btn">
        <i class="fa fa-phone-alt"></i>
    </a>
    <!-- end first whatsaap section -->
    <!-- start mobile whatsaap section -->
    <div class="mblbgc">
        <div class="container">
            <div class="row">
                <div class="col-lg-3 col-3 text-center">
                    <a href="https://wa.me/918929222323?text=" target=”_blank” class="whatsapp-btnmbl">
                        <i class="fab fa-whatsapp"></i>
                    </a>
                </div>
                <div class="col-lg-6 col-6 text-center ">
                    <a href="#" class="cart-btn mbltopmrgin" width="100"> <i class="fa fa-shopping-cart"
                            aria-hidden="true"></i> Order Now</a>
                </div>
                <div class="col-lg-3 col-3 text-center">
                    <a href="tel:+918929222323" target=”_blank” class="phone-btnmbl">
                        <i class="fa fa-phone-alt"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <!-- end mobile whatsaap section -->
    <!-- JS here -->
    <script src="assets/js/vendor/jquery-3.6.0.min.js"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/isotope.pkgd.min.js"></script>
    <script src="assets/js/imagesloaded.pkgd.min.js"></script>
    <script src="assets/js/jquery.magnific-popup.min.js"></script>
    <script src="assets/js/jquery.odometer.min.js"></script>
    <script src="assets/js/jquery.appear.js"></script>
    <script src="assets/js/jquery.paroller.min.js"></script>
    <script src="assets/js/jquery.easypiechart.min.js"></script>
    <script src="assets/js/jquery.inview.min.js"></script>
    <script src="assets/js/jquery.easing.js"></script>
    <script src="assets/js/jquery-ui.min.js"></script>
    <script src="assets/js/svg-inject.min.js"></script>
    <script src="assets/js/jarallax.min.js"></script>
    <script src="assets/js/slick.min.js"></script>
    <script src="assets/js/validator.js"></script>
    <script src="assets/js/ajax-form.js"></script>
    <script src="assets/js/wow.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/jquery.magnific-popup.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/lightcase/2.5.0/js/lightcase.js"></script>
    <script src="assets/js/main.js"></script>
    <script src="https://ebz-static.s3.ap-south-1.amazonaws.com/easecheckout/v2.0.0/easebuzz-checkout-v2.min.js"></script>
    <script>
        $(document).on('click', '#buynowbtn', function(event) {
            event.preventDefault();
            let form = $('#checkoutform');
            form.find('.error_form').remove();
            let formData = {
                first_name: form.find('input[name="first_name"]').val(),
                zip_code: form.find('input[name="zip_code"]').val(),
                address1: form.find('input[name="address1"]').val(),
                city: form.find('input[name="city"]').val(),
                state: form.find('input[name="state"]').val(),
                email: form.find('input[name="email"]').val(),
                phone: form.find('input[name="phone"]').val(),
                payment_method: form.find('input[name="payment_method"]:checked').val(),
                product_name: form.find('input[name="product_name"]').val(),
                product_price: form.find('input[name="product_price"]').val(),
                total_amount: form.find('input[name="total_amount"]').val()
            };
            let isValid = validateForm(form, formData);
            if (!isValid) {
                console.log('Form validation failed.');
                return false;
            }
            // console.log('input[name="payment_method"]').val()); return false;
            if (formData.payment_method == 'online') {
                initiateOnlinePayment(form, formData);
            } else {
                // console.log('cash...........');
                // return false;
                submitFormData(form, formData);
            }
        });

        function validateForm(form, data) {
            let isValid = true;

            function addError(inputName, errorMessage) {
                form.find(`input[name="${inputName}"]`).addClass('invalid')
                    .parent().append(`<p class="error_form">${errorMessage}</p>`);
                isValid = false;
            }
            if (!data.first_name.trim()) addError('first_name', 'Please enter a valid Name');
            if (!/^\d{6}$/.test(data.zip_code)) addError('zip_code', 'Please enter a valid Zip Code');
            if (!data.address1.trim()) addError('address1', 'Please enter your address');
            if (!data.city.trim()) addError('city', 'Please enter a valid City');
            if (!data.state.trim()) addError('state', 'Please enter a valid State');
            if (!/^\d{10}$/.test(data.phone)) addError('phone', 'Please enter a valid 10-digit Phone Number');
            if (!data.payment_method) addError('payment_method', 'Please select a Payment Method');
            if (!data.product_name.trim()) addError('product_name', 'Product Name is required');
            if (!data.product_price || isNaN(data.product_price)) addError('product_price', 'Please select a valid product price.');
            return isValid;
        }

        // function initiateOnlinePayment(form, formData) {
        //     // Transaction ID
        //     let base_url = "https://heightdetox.com/";
        //     let SendData = {
        //         txnid: `KAYA${Date.now()}${Math.floor(Math.random() * 1000000000).toString().padStart(9, '0')}`,
        //         firstname: form.find('input[name="first_name"]').val(),
        //         email: (form.find('input[name="email"]').val()) ? form.find('input[name="email"]').val() : 'as271070@gmail.com',
        //         amount: form.find('input[name="total_amount"]').val(),
        //         phone: form.find('input[name="phone"]').val(),
        //         productinfo: form.find('input[name="product_name"]').val(),
        //         surl: `${base_url}index.php`,
        //         furl: `${base_url}index.php`,
        //         udf1: '',
        //         udf2: '',
        //         udf3: '',
        //         udf4: '',
        //         udf5: '',
        //         address1: form.find('input[name="address1"]').val(),
        //         address2: '',
        //         city: form.find('input[name="city"]').val(),
        //         state: form.find('input[name="state"]').val(),
        //         country: 'India',
        //         zipcode: form.find('input[name="zip_code"]').val(),
        //         show_payment_mode: '',
        //     };
        //     $.ajax({
        //         type: 'POST',
        //         url: 'php-kit-update/easebuzz.php?api_name=initiate_payment_iframe',
        //         data: SendData,
        //         success: function(response) {
        //             var json_response = JSON.parse(response);
        //             console.log("response" + response)
        //             console.log("json_response" + json_response);
        //             var env = json_response['env'];
        //             if (json_response['status'] == 1) {
        //                 var easebuzzCheckout = new EasebuzzCheckout(json_response['key'], env);
        //                 var options = {
        //                     access_key: json_response['access_key'],
        //                     onResponse: (response_data) => {
        //                         console.log(JSON.stringify(response_data));
        //                         $('#progress_bar').addClass('d-none');
        //                         formData.append('buynowbtn', true);
        //                         formData.append('payment_res', JSON.stringify(response_data));
        //                         submitFormData(paymentData);
        //                     },
        //                     theme: '#123456' // color hex
        //                 }
        //                 easebuzzCheckout.initiatePayment(options);
        //             } else {
        //                 // loading
        //                 // document.getElementById('loading1').innerText = JSON.stringify(json_response);
        //                 $('#progress_bar').removeClass('d-none');
        //                 console.log(JSON.stringify(json_response));
        //                 alert(JSON.stringify(json_response));
        //             }
        //         }
        //     });

        // }

        function initiateOnlinePayment(form, formData) {
            let base_url = "https://heightdetox.com/";
            let SendData = {
                txnid: `KAYA${Date.now()}${Math.floor(Math.random() * 1000000000).toString().padStart(9, '0')}`,
                firstname: formData.first_name,
                email: formData.email ? formData.email : 'as271070@gmail.com',
                amount: formData.total_amount,
                phone: formData.phone,
                productinfo: formData.product_name,
                surl: `${base_url}index.php`,
                furl: `${base_url}index.php`,
                udf1: '',
                udf2: '',
                udf3: '',
                udf4: '',
                udf5: '',
                address1: formData.address1,
                address2: '',
                city: formData.city,
                state: formData.state,
                country: 'India',
                zipcode: formData.zip_code,
                show_payment_mode: '',
            };

            $.ajax({
                type: 'POST',
                url: 'php-kit-update/easebuzz.php?api_name=initiate_payment_iframe',
                data: SendData,
                success: function(response) {
                    try {
                        let json_response = JSON.parse(response);
                        console.log("Parsed JSON Response:", json_response);

                        if (json_response['status'] == 1) {
                            let easebuzzCheckout = new EasebuzzCheckout(json_response['key'], json_response['env']);
                            let options = {
                                access_key: json_response['access_key'],
                                onResponse: (response_data) => {
                                    console.log("Payment Response:", JSON.stringify(response_data));
                                    $('#progress_bar').addClass('d-none');

                                    if (response_data.status === "success") {
                                        let paymentData = new FormData(form[0]);
                                        paymentData.append('buynowbtn', true);
                                        paymentData.append('payment_res', JSON.stringify(response_data));
                                        submitFormData(form, paymentData); // Submit the form when payment is successful
                                    } else {
                                        alert("Payment failed. Please try again.");
                                        location.reload(); // Reload the page if payment failed
                                    }
                                },
                                // onResponse: (response_data) => {
                                //     console.log("Payment Response:", JSON.stringify(response_data));
                                //     $('#progress_bar').addClass('d-none');
                                //     let paymentData = new FormData(form[0]);
                                //     paymentData.append('buynowbtn', true);
                                //     paymentData.append('payment_res', JSON.stringify(response_data));
                                //     submitFormData(form, paymentData); // Corrected variable usage
                                // },
                                theme: '#123456' // Set the desired theme color here
                            };
                            easebuzzCheckout.initiatePayment(options);
                        } else {
                            $('#progress_bar').removeClass('d-none');
                            console.error("Payment initiation failed:", JSON.stringify(json_response));
                            alert(`Payment initiation failed: ${JSON.stringify(json_response)}`);
                        }
                    } catch (error) {
                        console.error("Error parsing JSON:", error);
                        alert("An error occurred while processing the response.");
                    }
                },
                error: function(xhr, status, error) {
                    console.error("AJAX Error:", status, error);
                    alert("An error occurred while initiating the payment. Please try again.");
                }
            });
        }


        function submitFormData(form, formData) {
            let formDataObj = new FormData(form[0]);
            formDataObj.append('buynowbtn', true);
            $.ajax({
                url: 'admin/controllers-abhay.php',
                method: 'POST',
                data: formDataObj,
                processData: false,
                contentType: false,
                dataType: 'json', 
                beforeSend: function() {
                    $('#progress_bar').removeClass('d-none');
                    $('#buynowbtn').prop('disabled', true); 
                    console.log('Submitting form...');
                },
                success: function(response) {
                    $('#progress_bar').addClass('d-none'); // Hide progress bar
                    $('#buynowbtn').prop('disabled', false); // Re-enable button

                    if (response.status) {
                        console.log('Success Response:', response);
                        // Redirect to the provided URL
                        window.location.replace(response.url); // Uncomment to enable
                    } else {
                        console.error('Error Response:', response.message);
                        alert(response.message); // Show error message from server response
                    }
                },
                error: function(xhr, status, error) {
                    $('#progress_bar').addClass('d-none'); // Hide progress bar on error
                    $('#buynowbtn').prop('disabled', false); // Re-enable button on error

                    console.error('AJAX Error:', status, error);
                    alert('There was an issue processing your request. Please try again.');
                }
            });
        }


        // function submitFormData(form, formData) {
        //     $.ajax({
        //         url: 'admin/controllers-abhay.php',
        //         method: 'POST',
        //         data: formData,
        //         processData: false,
        //         contentType: false,
        //         beforeSend: function() {
        //             $('#progress_bar').removeClass('d-none');
        //         },
        //         success: function(response) {
        //             $('#progress_bar').addClass('d-none');
        //             if (response.status) {
        //                 // console.log('Database Response:', response);
        //                 window.location.replace(response.url); // Uncomment when needed
        //             } else {
        //                 alert(response.message);
        //             }
        //         },
        //         error: function(xhr, status, error) {
        //             console.error('Submission Error:', error);
        //             alert('There was an issue processing your request. Please try again.');
        //         }
        //     });
        // }


        // AJAX form submission
        // function submitFormData(form, formData) {
        //     let formDataObj = new FormData(form[0]);
        //     formDataObj.append('buynowbtn', true);
        //     $.ajax({
        //         url: 'admin/controllers-abhay.php',
        //         method: 'POST',
        //         data: formDataObj,
        //         processData: false,
        //         contentType: false,
        //         beforeSend: function() {
        //             $('#progress_bar').removeClass('d-none');
        //         },
        //         success: function(response) {
        //             $('#progress_bar').addClass('d-none');
        //             if (response.status) {
        //                 console.log('RES_databse' + response)
        //                 // window.location.replace(response.url);
        //             } else {
        //                 alert(response.message);
        //             }
        //         },
        //         error: function(xhr, status, error) {
        //             console.error('Error occurred:', error);
        //             alert('There was an issue processing your request. Please try again.');
        //         }
        //     });
        // }
    </script>

    <script>
        // function digitValidate(input) {
        //     // Allow only numbers and handle backspace
        //     input.value = input.value.replace(/[^0-9]/g, ''); // Allow only numbers
        // }

        function tabChange(index) {
            const currentInput = document.getElementById(`otp${index}`);
            const nextInput = document.getElementById(`otp${index + 1}`);
            const prevInput = document.getElementById(`otp${index - 1}`);

            // When the current input is filled, move focus to the next one
            if (currentInput.value.length === 1 && nextInput) {
                nextInput.removeAttribute('disabled');
                nextInput.focus();
            }

            // When the backspace is pressed and the current input is empty, move focus to the previous one
            currentInput.addEventListener('keydown', function(event) {
                if (event.key === 'Backspace' && currentInput.value === '') {
                    if (prevInput) {
                        prevInput.focus();
                    }
                }
            });
        }
    </script>





</body>

</html>