<?php 
include('auth.php');
include('db-connection.php');
?>


<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="description" content="Web Development Solution is a professional service provider company envisioned to acclaim website related services and deploy an array of technologies to build-up brands over the Internet globally. Considering ourselves as a medium of change, our resolution is to provide brands an ultimate satisfaction to reinvent their world digitally. We create and build acquaintances you’re your clientele. Our definitive goal is to render your business an intelligent, exclusive, and direct reflection in the digital world to fetch you a high return.">
    <meta name="author" content="webdevelopmentsolution">
    <meta name="keywords" content="webdevelopmentsolution,Admin Login">
    <title>User List</title>

    <?php
    include('includes/header-links.php');
    ?>
</head>

<body>
    <div class="main-wrapper">
        <?php
        include('includes/left-sidebar.php');
        ?>
        <div class="page-wrapper">
            <?php
            include('includes/topbar.php');
            ?>
            <div class="page-content">
                <div class="d-flex justify-content-between align-items-center flex-wrap grid-margin">
                    <div>
                        <h4 class="mb-3 mb-md-0">Users Management</h4>
                    </div>
                    <div class="d-flex align-items-center flex-wrap text-nowrap btn btn-primary btn-icon-text d-none">
                        <a href="add-user.php" style="color:#fff !important;"><i class="fa fa-user"></i> + Users</a>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12 col-xl-12 grid-margin stretch-card">
                        <div class="card overflow-hidden">
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-striped table-hover" id="userdatatable" style=" width: auto !important; ">
                                        <thead class="thead-light">
                                            <tr>
                                                <th>SN</th>
                                                <th>Name</th>
                                                <th>Mobile</th>
                                                <th>Email</th>
                                                <th>status</th>
                                                <th>Address</th>
                                                <th>Date</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $query_order = 'SELECT u.*, COUNT(o.id) AS total_order FROM tbl_user AS u LEFT JOIN tbl_order AS o ON u.id = o.user_id GROUP BY u.id ORDER BY u.created_at DESC';
                                            $result = mysqli_query($link, $query_order);
                                            if ($result && mysqli_num_rows($result) > 0) {
                                                $sn = 0;
                                                while ($row = mysqli_fetch_assoc($result)) {
                                                    $sn++;
                                            ?>
                                                    <tr>
                                                        <td><?= $sn ?></td>
                                                        <td><?= $row['name'] ?> [<?= $row['total_order'] ?>]</td>
                                                        <td><?= $row['mobile'] ?></td>
                                                        <td><?= $row['email'] ?></td>
                                                        <td>
                                                            <?php
                                                            switch ($row['status']) {
                                                                case 1:
                                                                    echo 'Lead';
                                                                    break;
                                                                case 2:
                                                                    echo 'Lead';
                                                                    break;
                                                                case 3:
                                                                    echo 'Product Lead';
                                                                    break;
                                                                case 4:
                                                                    echo 'checkout pages';
                                                                    break;
                                                                default:
                                                                    echo 'Unknown status';
                                                                    break;
                                                            }
                                                            ?>
                                                        </td>
                                                        <td>
                                                            <?= $row['zip_code'] ?> <br>
                                                            <?= $row['house_no'] ?> <br>
                                                            <?= $row['landmark'] ?> <br>
                                                            <?= $row['city'] ?> <br>
                                                            <?= $row['state'] ?>
                                                        </td>
                                                        <td>
                                                            <?php
                                                            echo date('d-M-Y h:i a', strtotime($row['created_at']));
                                                            ?>
                                                        </td>
                                                    </tr>
                                            <?php
                                                }
                                            }
                                            ?>

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <?php
            include('includes/footer.php');
            ?>
            <style>
                table.dataTable thead th .dt-column-order:before {
                    font-family: FontAwesome;
                    padding-left: 5px;
                    content: "\f0dc";
                    /* FontAwesome 'sort' icon (default) */
                }

                table.dataTable thead th.sorting_asc .dt-column-order:before {
                    content: "\f160";
                    /* FontAwesome 'sort-up' icon for ascending */
                }

                table.dataTable thead th.sorting_desc .dt-column-order:before {
                    content: "\f161";
                    /* FontAwesome 'sort-down' icon for descending */
                }
            </style>

            <script>
                $(document).ready(function() {
                    $('#userdatatable').DataTable({
                        "paging": true,
                        "searching": true,
                        "ordering": true, // Ensures that columns are sortable
                        "info": true,
                        "lengthChange": true,
                        "pageLength": 5,
                        "columnDefs": [{
                                "orderable": false,
                                "targets": [4]
                            } // Disable sorting for specific columns (if needed)
                        ]

                    });
                });
            </script>