<?php 
include('auth.php');
include('db-connection.php');
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="description" content="Web Development Solution is a professional service provider company envisioned to acclaim website related services and deploy an array of technologies to build-up brands over the Internet globally. Considering ourselves as a medium of change, our resolution is to provide brands an ultimate satisfaction to reinvent their world digitally. We create and build acquaintances you’re your clientele. Our definitive goal is to render your business an intelligent, exclusive, and direct reflection in the digital world to fetch you a high return.">
    <meta name="author" content="webdevelopmentsolution">
    <meta name="keywords" content="webdevelopmentsolution,Admin Login">
    <title>Admin Dashboard</title>
    <?php
    include('includes/header-links.php');
    ?>
</head>

<body>
    <div class="main-wrapper">
      
        <?php
        include('includes/left-sidebar.php');
        ?>
        
        
        <div class="page-wrapper">
            <?php
            include('includes/topbar.php');


            //fatch data tbl_order
            $query_order = 'SELECT o.*, u.name, u.mobile, u.email, u.zip_code, u.landmark, u.house_no,u.city,u.state FROM `tbl_order` as o LEFT JOIN tbl_user as u on u.id=o.user_id ORDER BY o.id DESC';
            $result = mysqli_query($link, $query_order);
            
            
            //echo 'test';
            
            ?>

            ?>
            <div class="page-content">
                <div class="d-flex justify-content-between align-items-center flex-wrap grid-margin">
                    <div>
                        <h4 class="mb-3 mb-md-0">Order Management</h4>
                    </div>
                    <div class="d-flex align-items-center flex-wrap text-nowrap">
                    </div>
                </div>
                <div class="row">
                    <div class="col-12 col-xl-12 grid-margin stretch-card">
                        <div class="card overflow-hidden">
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table id="dataTableExample" class="table">
                                        <thead>
                                            <tr>
                                                <th>SN</th>
                                                <th>Product Name</th>
                                                <th>Name</th>
                                                <th>Mobile</th>
                                                <th>Email</th>
                                                <th>status</th>
                                                <th>Address</th>
                                                <th>Date</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            if ($result && mysqli_num_rows($result) > 0) {
                                                $sn = 0;
                                                while ($row = mysqli_fetch_assoc($result)) {
                                                    $sn++;
                                            ?>
                                                    <tr>
                                                        <td><?= $sn ?></td>
                                                        <td><?= $row['product_name'] ?></td>
                                                        <td><?= $row['name'] ?></td>
                                                        <td><?= $row['mobile'] ?></td>
                                                        <td><?= $row['email'] ?></td>
                                                        <td>
                                                            <?php

                                                            switch ($row['status']) {
                                                                case 1:
                                                                    echo 'User Lead';
                                                                    break;
                                                                case 2:
                                                                    echo 'User Product Lead';
                                                                    break;
                                                                case 3:
                                                                    echo 'User checkout saved';
                                                                    break;
                                                                case 4:
                                                                    echo 'Cash On Delivery';
                                                                    break;
                                                                case 5:
                                                                    echo 'online Payment successful ';
                                                                    break;
                                                                case 6:
                                                                    echo 'online Payment failed';
                                                                    break;
                                                                default:
                                                                    echo 'Unknown status';
                                                                    break;
                                                            }
                                                            ?>
                                                        </td>
                                                        <td>
                                                            <?= $row['zip_code'] ?> <br>
                                                            <?= $row['house_no'] ?> <br>
                                                            <?= $row['landmark'] ?> <br>
                                                            <?= $row['city'] ?> <br>
                                                            <?= $row['state'] ?>
                                                        </td>
                                                        <td>
                                                            <?php
                                                            echo date('d-M-Y h:i a', strtotime($row['created_at']));
                                                            ?>
                                                        </td>
                                                    </tr>
                                            <?php
                                                }
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> <!-- row -->
            </div>
            <?php
            include('includes/footer.php');
            ?>